/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class EntityGelatinousCube
extends EntityCubic {
    private int block_feeding_countdown;
    private int item_feeding_countdown;
    private int data_object_id_is_feeding;
    private static final int OFFSET_BLOCK_ID = 0;
    private static final int OFFSET_BLOCK_DIMENSION = 1;
    private static final int OFFSET_BLOCK_X = 2;
    private static final int OFFSET_BLOCK_Y = 3;
    private static final int OFFSET_BLOCK_Z = 4;
    private static final int OFFSET_BLOCK_PROGRESS = 5;
    private static final int DISSOLVING_BLOCK_FIELDS = 6;
    private static final int MAX_NUM_DISSOLVING_BLOCKS = 64;
    private int[] dissolving_blocks_info = new int[384];
    private List extended_dissolving_blocks_info = new ArrayList();
    private int ticks_until_next_fizz_sound;

    public EntityGelatinousCube(abw world) {
        super(world);
    }

    @Override
    protected void a() {
        super.a();
        this.data_object_id_is_feeding = this.ah.addObject(this.ah.getNextAvailableId(), new Byte(0));
    }

    protected boolean setIsFeeding(boolean is_feeding) {
        this.ah.b(this.data_object_id_is_feeding, (byte)(is_feeding ? -1 : 0));
        return is_feeding;
    }

    public boolean isFeeding() {
        return this.ah.a(this.data_object_id_is_feeding) != 0;
    }

    private void updateIsFeedingFlag() {
        this.setIsFeeding(this.block_feeding_countdown > 0 || this.item_feeding_countdown > 0);
    }

    public boolean isBlockFeedingCountdownAboveZero() {
        return this.block_feeding_countdown > 0;
    }

    public void setBlockFeedingCountdown(int block_feeding_countdown) {
        this.block_feeding_countdown = ls.a(block_feeding_countdown, 0, 20);
        this.updateIsFeedingFlag();
    }

    public void setItemFeedingCountdown(int item_feeding_countdown) {
        this.item_feeding_countdown = ls.a(item_feeding_countdown, 0, 20);
        this.updateIsFeedingFlag();
    }

    @Override
    public void b(by par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("dissolving_blocks_info", this.dissolving_blocks_info);
        if (!this.extended_dissolving_blocks_info.isEmpty()) {
            int[] spliced = new int[this.extended_dissolving_blocks_info.size() * 6];
            int index = -1;
            for (int[] info : this.extended_dissolving_blocks_info) {
                for (int offset = 0; offset < 6; ++offset) {
                    spliced[++index] = info[offset];
                }
            }
            par1NBTTagCompound.a("extended_dissolving_blocks_info", spliced);
        }
    }

    @Override
    public void a(by par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        if (par1NBTTagCompound.b("dissolving_blocks_info")) {
            this.dissolving_blocks_info = par1NBTTagCompound.k("dissolving_blocks_info");
            if (this.dissolving_blocks_info.length < 384) {
                int[] temp = this.dissolving_blocks_info;
                this.dissolving_blocks_info = new int[384];
                for (int i2 = 0; i2 < temp.length; ++i2) {
                    this.dissolving_blocks_info[i2] = temp[i2];
                }
            }
        }
        if (par1NBTTagCompound.b("extended_dissolving_blocks_info")) {
            int[] spliced = par1NBTTagCompound.k("extended_dissolving_blocks_info");
            int num_infos = spliced.length / 6;
            for (int i3 = 0; i3 < num_infos; ++i3) {
                int base_offset = i3 * 6;
                int[] info = new int[]{spliced[base_offset + 0], spliced[base_offset + 1], spliced[base_offset + 2], spliced[base_offset + 3], spliced[base_offset + 4], spliced[base_offset + 5]};
                this.extended_dissolving_blocks_info.add(info);
            }
        }
    }

    private BlockInfo[] getBlocksOccupiedWithStandardExpansion() {
        return this.getBlocksOccupied(0.01f, 0.01f, 0.01f, 0.01f, true);
    }

    @Override
    public int getJumpDelay(nn target) {
        if (target == null) {
            return this.ab.nextInt(81) + 40;
        }
        return 10;
    }

    @Override
    protected void bl() {
        BlockInfo[] infos = this.getBlocksOccupiedWithStandardExpansion();
        for (int i2 = 0; i2 < infos.length; ++i2) {
            BlockInfo info = infos[i2];
            if (info == null) continue;
            aqz block = info.block;
            int x2 = info.x;
            int y2 = info.y;
            int z2 = info.z;
            int dissolve_period = this.getDissolvePeriod(info.block, x2, y2, z2);
            if (dissolve_period == 0 || block instanceof arg || block instanceof anr) {
                if (this.q.isBlockSolid(x2, y2, z2)) {
                    this.q.destroyBlockWithoutDroppingItem(x2, y2, z2, this.isAcidic() ? EnumBlockFX.smoke_and_steam : EnumBlockFX.steam);
                    continue;
                }
                this.onCollidedWithBlock(this.q, block, x2, y2, z2);
                continue;
            }
            if (dissolve_period <= 0) continue;
            this.setBlockFeedingCountdown(20);
            break;
        }
        super.bl();
    }

    @Override
    public void onCollidedWithBlock(abw world, aqz block, int x2, int y2, int z2) {
        if (this.onServer() && block.doRenderBoundsIntersectWith(world, x2, y2, z2, this.E)) {
            if (block instanceof arg) {
                world.destroyBlockWithoutDroppingItem(x2, y2, z2, EnumBlockFX.smoke_and_steam);
                this.attackEntityFrom(new Damage(nb.a, 1.0f));
                return;
            }
            if (this.dissolvesBlockInstantly(x2, y2, z2)) {
                world.destroyBlockWithoutDroppingItem(x2, y2, z2, this.isAcidic() ? EnumBlockFX.smoke_and_steam : EnumBlockFX.steam);
                return;
            }
            if (block instanceof anr) {
                anr crops = (anr)block;
                crops.setBlighted(world, x2, y2, z2, true);
            }
        }
        super.onCollidedWithBlock(world, block, x2, y2, z2);
    }

    private void setDissolvingBlock(aqz block, int x2, int y2, int z2, int dissolving_progress) {
        for (int i2 = 0; i2 < 64; ++i2) {
            int base_offset = i2 * 6;
            if (this.dissolving_blocks_info[base_offset + 0] != 0) continue;
            this.dissolving_blocks_info[base_offset + 0] = block.cF;
            this.dissolving_blocks_info[base_offset + 1] = this.q.getDimensionId();
            this.dissolving_blocks_info[base_offset + 2] = x2;
            this.dissolving_blocks_info[base_offset + 3] = y2;
            this.dissolving_blocks_info[base_offset + 4] = z2;
            this.dissolving_blocks_info[base_offset + 5] = dissolving_progress;
            return;
        }
        Debug.setErrorMessage("setDissolvingBlock: wasn't able to add another block");
    }

    private int isDissolvingBlock(aqz block, int x2, int y2, int z2) {
        for (int i2 = 0; i2 < 64; ++i2) {
            int base_offset = i2 * 6;
            if (this.dissolving_blocks_info[base_offset + 0] != block.cF || this.dissolving_blocks_info[base_offset + 1] != this.q.getDimensionId() || this.dissolving_blocks_info[base_offset + 2] != x2 || this.dissolving_blocks_info[base_offset + 3] != y2 || this.dissolving_blocks_info[base_offset + 4] != z2) continue;
            return i2;
        }
        return -1;
    }

    public int isDissolvingBlock(BlockInfo info) {
        return this.isDissolvingBlock(info.block, info.x, info.y, info.z);
    }

    public int getDissolvePeriod(aqz block, int x2, int y2, int z2) {
        int ticks = block.getDissolvePeriod(this.q, x2, y2, z2, this.getDamageTypeVsItems());
        return ticks >= 0 ? ticks / 20 : -1;
    }

    public boolean canDissolveBlockGradually(int x2, int y2, int z2) {
        aqz block = this.q.getBlock(x2, y2, z2);
        return block != null && this.getDissolvePeriod(block, x2, y2, z2) > 0;
    }

    public boolean canDissolveBlockGradually(BlockInfo info) {
        return this.canDissolveBlockGradually(info.x, info.y, info.z);
    }

    public boolean dissolvesBlockInstantly(int x2, int y2, int z2) {
        aqz block = this.q.getBlock(x2, y2, z2);
        return block != null && this.getDissolvePeriod(block, x2, y2, z2) == 0;
    }

    private boolean isSameBlock(int index, BlockInfo info) {
        if (info == null) {
            return false;
        }
        int base_offset = index * 6;
        if (this.dissolving_blocks_info[base_offset + 0] != info.block.cF) {
            return false;
        }
        if (this.dissolving_blocks_info[base_offset + 1] != this.q.getDimensionId()) {
            return false;
        }
        if (this.dissolving_blocks_info[base_offset + 2] != info.x) {
            return false;
        }
        if (this.dissolving_blocks_info[base_offset + 3] != info.y) {
            return false;
        }
        return this.dissolving_blocks_info[base_offset + 4] == info.z;
    }

    private boolean isBlockFoundInBlockInfos(int index, BlockInfo[] infos) {
        for (int i2 = 0; i2 < infos.length; ++i2) {
            if (!this.isSameBlock(index, infos[i2])) continue;
            return true;
        }
        return false;
    }

    private void storeExtendedDissolvingBlockInfo(int base_offset) {
        int[] info2;
        for (int[] info2 : this.extended_dissolving_blocks_info) {
            boolean matches = true;
            for (int offset = 0; offset < 5; ++offset) {
                if (info2[offset] == this.dissolving_blocks_info[base_offset + offset]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            info2[5] = this.dissolving_blocks_info[base_offset + 5];
            return;
        }
        info2 = new int[6];
        for (int offset = 0; offset < 6; ++offset) {
            info2[offset] = this.dissolving_blocks_info[base_offset + offset];
        }
        this.extended_dissolving_blocks_info.add(info2);
    }

    private int getProgressFromExtendedDissolvingBlockInfo(aqz block, int block_dimension, int x2, int y2, int z2) {
        for (int[] info : this.extended_dissolving_blocks_info) {
            if (info[0] != block.cF || info[1] != block_dimension || info[2] != x2 || info[3] != y2 || info[4] != z2) continue;
            return info[5];
        }
        return 0;
    }

    private void pruneExtendedDissolvingBlockInfo() {
        Iterator i2 = this.extended_dissolving_blocks_info.iterator();
        while (i2.hasNext()) {
            int[] info = (int[])i2.next();
            int x2 = info[2];
            int y2 = info[3];
            int z2 = info[4];
            if (this.q.getDimensionId() == info[1] && this.getDistanceSqToBlock(x2, y2, z2) < 256.0 && this.q.getBlock(x2, y2, z2) == aqz.getBlock(info[0])) continue;
            i2.remove();
        }
    }

    @Override
    public void spentTickInLava() {
        super.spentTickInLava();
        if (!this.M) {
            if (this.onClient()) {
                this.spawnSteamParticles(5);
                this.spawnLargeSmokeParticles(5);
            } else if (--this.ticks_until_next_fizz_sound <= 0) {
                this.a("random.fizz", 0.7f, 1.6f + (this.ab.nextFloat() - this.ab.nextFloat()) * 0.4f);
                this.ticks_until_next_fizz_sound = this.ab.nextInt(7) + 2;
            }
        }
    }

    @Override
    public void c() {
        if (this.onServer()) {
            if (this.block_feeding_countdown > 0) {
                --this.block_feeding_countdown;
                this.updateIsFeedingFlag();
            }
            if (this.item_feeding_countdown > 0) {
                --this.item_feeding_countdown;
                this.updateIsFeedingFlag();
            }
            if (this.getTicksExistedWithOffset() % 20 == 0) {
                this.pruneExtendedDissolvingBlockInfo();
                BlockInfo[] infos = this.getBlocksOccupiedWithStandardExpansion();
                for (int i2 = 0; i2 < 64; ++i2) {
                    int base_offset = i2 * 6;
                    if (this.dissolving_blocks_info[base_offset + 0] == 0 || this.isBlockFoundInBlockInfos(i2, infos)) continue;
                    this.storeExtendedDissolvingBlockInfo(base_offset);
                    this.dissolving_blocks_info[base_offset + 0] = 0;
                }
                boolean clear_block_feeding_counter = true;
                for (int i3 = 0; i3 < infos.length; ++i3) {
                    BlockInfo info = infos[i3];
                    if (info == null) continue;
                    aqz block = info.block;
                    int x2 = info.x;
                    int y2 = info.y;
                    int z2 = info.z;
                    if (this.q.getBlock(x2, y2, z2) != block) {
                        int index = this.isDissolvingBlock(info);
                        if (index < 0) continue;
                        this.dissolving_blocks_info[index * 6 + 0] = 0;
                        continue;
                    }
                    int dissolve_period = this.getDissolvePeriod(block, x2, y2, z2);
                    if (dissolve_period < 1) continue;
                    int index = this.isDissolvingBlock(info);
                    if (index < 0) {
                        int progress = this.getProgressFromExtendedDissolvingBlockInfo(block, this.q.getDimensionId(), x2, y2, z2);
                        this.setDissolvingBlock(block, x2, y2, z2, progress);
                        index = this.isDissolvingBlock(info);
                    }
                    int base_offset = index * 6;
                    int n2 = base_offset + 5;
                    this.dissolving_blocks_info[n2] = this.dissolving_blocks_info[n2] + this.getSize();
                    if (this.dissolving_blocks_info[base_offset + 5] >= dissolve_period) {
                        this.q.destroyBlockWithoutDroppingItem(x2, y2, z2, this.isAcidic() ? EnumBlockFX.smoke_and_steam : EnumBlockFX.steam);
                        this.dissolving_blocks_info[base_offset + 0] = 0;
                        continue;
                    }
                    this.q.blockFX(EnumBlockFX.steam_particles_only, x2, y2, z2);
                    clear_block_feeding_counter = false;
                }
                this.setBlockFeedingCountdown(clear_block_feeding_counter ? 0 : 20);
                List entity_items = this.q.a(ss.class, this.E);
                boolean refresh_counter = false;
                if (entity_items != null) {
                    for (int i4 = 0; i4 < entity_items.size(); ++i4) {
                        EntityDamageResult result;
                        ItemVessel item_vessel;
                        ss entity_item = (ss)entity_items.get(i4);
                        if (entity_item.M) continue;
                        if (entity_item.b < 60) {
                            entity_item.b = 60;
                        }
                        if (entity_item.isVessel() && !(item_vessel = (ItemVessel)entity_item.d().b()).isEmpty()) {
                            akc contents = item_vessel.getContents();
                            if (contents == akc.i) {
                                this.attackEntityFrom(new Damage(nb.c, 5.0f));
                                this.q.blockFX(EnumBlockFX.smoke_and_steam, entity_item.getBlockPosX(), entity_item.getBlockPosY(), entity_item.getBlockPosZ());
                                entity_item.convertItem(item_vessel.getPeerForContents(akc.stone));
                            } else if (contents == akc.h) {
                                entity_item.convertItem(item_vessel.getEmptyVessel());
                            }
                        }
                        if ((result = entity_item.attackEntityFrom(new Damage(this.getDamageTypeVsItems(), 1.0f))) == null || !result.entityWasNegativelyAffectedButNotDestroyed()) continue;
                        refresh_counter = true;
                    }
                }
                this.setItemFeedingCountdown(refresh_counter ? 20 : 0);
            }
        }
        super.c();
    }

    public abstract nb getDamageTypeVsItems();

    @Override
    public void onMeleeAttacked(of attacker, EntityDamageResult result) {
        uf player;
        super.onMeleeAttacked(attacker, result);
        if (attacker.isEntityPlayer() && attacker.hasHeldItem() && player.bn.takeDamage((player = attacker.getAsPlayer()).getHeldItemStack(), this.getDamageTypeVsItems(), this.getAttackStrengthMultiplierForType())) {
            player.entityFX(EnumEntityFX.steam_with_hiss);
        }
    }

    @Override
    public void tryAddArrowToContainedItems(uh entity_arrow) {
        ItemArrow item_arrow;
        if (this.isAcidic() && (item_arrow = entity_arrow.item_arrow).isHarmedByAcid()) {
            entity_arrow.entityFX(EnumEntityFX.steam_with_hiss);
            return;
        }
        super.tryAddArrowToContainedItems(entity_arrow);
    }

    @Override
    protected final int s() {
        return this.getSize() == 1 ? yc.aO.cv : 0;
    }

    @Override
    public float getClimbingSpeed() {
        return 0.2f;
    }

    @Override
    public int getExperienceValue() {
        return this.getSize() * (this.getAttackStrengthMultiplierForType() + (this.isAcidic() ? 1 : 0));
    }

    @Override
    public boolean canDouseFire() {
        return true;
    }

    @Override
    public boolean canCatchFire() {
        return false;
    }

    @Override
    public final boolean attacksAnimals() {
        return true;
    }

    @Override
    public final boolean attacksVillagers() {
        return true;
    }
}

